/****** Object:  StoredProcedure [dbo].[P_MEDIAF_CALCULAR_Lj]    Script Date: 03/26/2014 11:44:31 ******/

IF EXISTS
(
	SELECT *
	FROM sys.objects
	WHERE object_id = OBJECT_ID(N'[dbo].[P_MEDIAF_CALCULAR]')
		  AND type IN(N'P', N'PC')
)
	DROP PROCEDURE [dbo].[P_MEDIAF_CALCULAR];
GO 

/****** Object:  StoredProcedure [dbo].[P_MEDIAF_CALCULAR_Lj]    Script Date: 03/26/2014 11:44:31 ******/

SET ANSI_NULLS ON;
GO

SET QUOTED_IDENTIFIER ON;
GO
--Versao 2909


CREATE PROCEDURE [dbo].[P_MEDIAF_CALCULAR] @CD_EMP   INT = 1
										 , @CD_USU   INT = 1
										 , @CONSULTA INT = 0
WITH ENCRYPTION
AS
	 SET DEADLOCK_PRIORITY HIGH;
	 SET NOCOUNT ON;
	 --Calcular parmetros de datas

	 DECLARE
			@DT_INI   DATETIME
		  , @DT_FIM   DATETIME
		  , @AGORA    DATETIME
		  , @ANO_MES0 INT
		  , @ANO_MES1 INT
		  , @ANO_MES2 INT
		  , @ANO_MES3 INT;

	 SELECT @DT_FIM = DBO.F_ONTEM() --Dia anterior
		  , @DT_INI = DATEADD(day, -29, @DT_FIM) --1 ms e 1 dia atrs
		  , @AGORA = CONVERT(    DATETIME, CONVERT(VARCHAR(10), GETDATE(), 112))
		  , @ANO_MES0 = CONVERT( CHAR(6), @DT_FIM, 112) --esse ms
		  , @ANO_MES1 = CONVERT( CHAR(6), DATEADD(MONTH, -1, @DT_FIM), 112) --ms anterior
		  , @ANO_MES2 = CONVERT( CHAR(6), DATEADD(MONTH, -2, @DT_FIM), 112) --2 meses atrs
		  , @ANO_MES3 = CONVERT( CHAR(6), DATEADD(MONTH, -3, @DT_FIM), 112); --3 meses atrs

	 SELECT @ANO_MES1 ANO_MES1
		  , @ANO_MES2 ANO_MES2
		  , @ANO_MES3 ANO_MES3
		  , @DT_FIM DT_FIM
		  , @DT_INI DT_INI;
	 --return
	 --tabela temporria que conter a base do clculo

	 CREATE TABLE #RS_PROD
	 (CD_FILIAL       INT
	, CD_PROD         INT
	, P1              MONEY
	, P2              MONEY
	, PPV             MONEY
	, QT_IT_ATUAL     MONEY
	, QT_IT_MES1      MONEY
	, QT_IT_MES2      MONEY
	, QT_IT_MES3      MONEY
	, QT_IT_ATUAL_GRV MONEY
	, QT_IT_MES1_GRV  MONEY
	, QT_IT_MES2_GRV  MONEY
	, QT_IT_MES3_GRV  MONEY
	, MEDIA3M         MONEY
	, SAZ             INT
	, LIMITP AS MEDIA3M + (MEDIA3M * (PPV / 100.0000))
	, LIMITV AS MEDIA3M - (MEDIA3M * (PPV / 100.0000))
	, DT_NASC         DATETIME
	 );

	 CREATE TABLE #TBL_BASE
	 (CD_EMP    INT
	, CD_FILIAL INT
	, CD_PROD   INT
	, ANO_MES   VARCHAR(15)
	, QT_IT     MONEY
	 );

	 CREATE TABLE #RS_TMP_ARV
	 (CD_EMP    INT
	, CD_FILIAL INT
	, CD_PROD   INT
	, P1_SAZ    MONEY
	, P2_SAZ    MONEY
	, P1        MONEY
	, P2        MONEY
	, PPV       MONEY
	, DT_NASC   DATETIME
	 );

	 PRINT 'Carregou parametos auxiliares '+CONVERT(VARCHAR, GETDATE(), 108);


	BEGIN TRY

		INSERT INTO EST_PROD_CPL_MEDIAF
		(CD_EMP
	   , CD_FILIAL
	   , CD_PROD
	   , CD_SIGLA
	   , QTDE_MEDIAF
	   , QTDE_FINANCIADO
	   , QTDE_FACEAMENTO
	   , QTDE_LIMITADOR
	   , VALID_QTDE_FACEAMENTO
	   , QT_VD_ATUAL
	   , QT_VD_MES1
	   , QT_VD_MES2
	   , QT_VD_MES3
	   , LIMITP
	   , LIMITV
	   , CD_USU
	   , DT_CAD
	   , DT_ULT_ALT
	   , SAZ
	   , DT_NASC
	   , MEDIAF_TRANSF
		)
			   SELECT A.CD_EMP
					, A.CD_FILIAL
					, A.CD_PROD
					, A.CD_SIGLA
					, MEDIAF QTDE_MEDIAF
					, 0 QTDE_FINANCIADO
					, 0 QTDE_FACEAMENTO
					, 0 QTDE_LIMITADOR
					, NULL VALID_QTDE_FACEAMENTO
					, 0 QT_VD_ATUAL
					, 0 QT_VD_MES1
					, 0 QT_VD_MES2
					, 0 QT_VD_MES3
					, 0 LIMITP
					, 0 LIMITV
					, 1 CD_USU
					, GETDATE() DT_CAD
					, NULL DT_ULT_ALT
					, 0 SAZ
					, NULL DT_NASC
					, 0 MEDIAF_TRANSF
			   FROM EST_PROD_CPL A
					LEFT JOIN EST_PROD_CPL_MEDIAF B ON A.CD_EMP = B.CD_EMP
													   AND A.CD_FILIAL = B.CD_FILIAL
													   AND A.CD_PROD = B.CD_PROD
			   WHERE B.CD_EMP IS NULL
					 AND A.CD_EMP = @CD_EMP;

		PRINT 'Carregou produtos na tabela de mediaf '+CONVERT(VARCHAR, GETDATE(), 108);
		--Efetuar os clculos e registrar na tabela temporria

		INSERT INTO #RS_TMP_ARV
			   SELECT N.CD_EMP
					, N.CD_FILIAL
					, N.CD_PROD
					, arv.P1_SAZ
					, arv.P2_SAZ
					, arv.P1
					, arv.P2
					, arv.PPV
					, N.DT_NASC
			   FROM V_EST_PROD_EST_ARV_MERCADOLOGICA ARV
					INNER JOIN EST_PROD_CPL_NASC n ON arv.CD_EMP = n.CD_EMP
													  AND arv.CD_FILIAL = n.CD_FILIAL
													  AND arv.CD_PROD = n.CD_PROD
			   WHERE arv.CD_EMP = 1
					 AND n.MEDIA_F_LIBERADA = 1
					 AND (ARV.FREAV_MEDIAF_ULT_ATU IS NULL OR ARV.PROXIMO_RECALC <= @AGORA); 
					 

		PRINT 'Carregou parametos arvore mercadologica '+CONVERT(VARCHAR, GETDATE(), 108);
		CREATE UNIQUE CLUSTERED INDEX #IX_RS_TMP_ARV ON #RS_TMP_ARV(CD_PROD, CD_FILIAL, CD_EMP);


		INSERT INTO #TBL_BASE
			   SELECT @CD_EMP AS CD_EMP
					, I.CD_FILIAL
					, i.CD_PROD
					, 'QT_IT_ATUAL' AS ANO_MES
					, SUM(i.QT_IT) AS QT_IT
			   FROM V_PDV_VD_IT i
					INNER JOIN #RS_TMP_ARV arv ON i.CD_EMP = arv.CD_EMP
												  AND i.CD_FILIAL = arv.CD_FILIAL
												  AND i.CD_PROD = arv.CD_PROD
			   WHERE I.CD_EMP = @CD_EMP
					 AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM  --Vendas dos ultimos trinta dias  
			   GROUP BY I.CD_FILIAL
					  , i.CD_PROD;

		PRINT 'Carregou venda ultimos 30 dias '+CONVERT(VARCHAR, GETDATE(), 108);

		INSERT INTO #TBL_BASE
		  SELECT @CD_EMP AS CD_EMP
				, arv.CD_FILIAL
				, arv.CD_PROD 
				--CASE mov.ANO_MES	WHEN 
				, CASE(mov.ANO * 100 + mov.MES) WHEN @ANO_MES1
				    THEN 'QT_IT_MES1'
				    WHEN @ANO_MES2
				    THEN 'QT_IT_MES2'
				    WHEN @ANO_MES3
				    THEN 'QT_IT_MES3'
				END
				, SUM(isnull(mov.QT_VD,0)) AS QT_IT
		  FROM 
			 EST_PROD_CPL_VD mov
			 RIGHT JOIN #RS_TMP_ARV arv ON mov.CD_EMP = arv.CD_EMP
										  AND mov.CD_FILIAL = arv.CD_FILIAL
										  AND mov.CD_PROD = arv.CD_PROD
			 AND  (mov.ANO * 100 + mov.MES) BETWEEN @ANO_MES3 AND @ANO_MES1
		  WHERE    
			 arv.CD_EMP = @CD_EMP
		  GROUP BY 
			   arv.CD_FILIAL
			 , arv.CD_PROD
			 , mov.ANO
			 , mov.MES;

		PRINT 'Carregou venda ultimos 3 meses '+CONVERT(VARCHAR, GETDATE(), 108);

		INSERT INTO #RS_PROD (CD_FILIAL	   , CD_PROD	   , P1	   , P2	   , PPV	   , QT_IT_ATUAL	   , QT_IT_MES1	   , QT_IT_MES2	   , QT_IT_MES3	   , QT_IT_ATUAL_GRV
							 , QT_IT_MES1_GRV	   , QT_IT_MES2_GRV	   , QT_IT_MES3_GRV	   , MEDIA3M	   , SAZ	   , DT_NASC		)
		  SELECT MOV.CD_FILIAL
				, MOV.CD_PROD
				, arv.P1
				, arv.P2
				, arv.PPV
				, MOV.QT_IT_ATUAL
				, MOV.QT_IT_MES1
				, MOV.QT_IT_MES2
				, MOV.QT_IT_MES3
				, MOV.QT_IT_ATUAL
				, MOV.QT_IT_MES1
				, MOV.QT_IT_MES2
				, MOV.QT_IT_MES3
				, (QT_IT_ATUAL * (arv.P1 / 100.0000)) + (((MOV.QT_IT_MES1 + MOV.QT_IT_MES2 + MOV.QT_IT_MES3) / 3.0000) * (arv.P2 / 100.0000)) MEDIA3M
				, 0
				, ARV.DT_NASC
		  FROM
		  (
			 SELECT CD_EMP
				    , CD_FILIAL
				    , CD_PROD
				    , ISNULL([QT_IT_ATUAL], 0) AS QT_IT_ATUAL
				    , ISNULL([QT_IT_MES1], 0) AS QT_IT_MES1
				    , ISNULL([QT_IT_MES2], 0) AS QT_IT_MES2
				    , ISNULL([QT_IT_MES3], 0) AS QT_IT_MES3
			 FROM #TBL_BASE PIVOT(SUM(QT_IT) FOR ANO_MES IN([QT_IT_ATUAL]
														  , [QT_IT_MES1]
														  , [QT_IT_MES2]
														  , [QT_IT_MES3])) AS pvt
		  ) MOV
		  INNER JOIN #RS_TMP_ARV arv ON MOV.CD_EMP = arv.CD_EMP
									   AND MOV.CD_FILIAL = arv.CD_FILIAL
									   AND MOV.CD_PROD = arv.CD_PROD;


		PRINT 'Carregou tabela base de analise '+CONVERT(VARCHAR, GETDATE(), 108);
		CREATE UNIQUE CLUSTERED INDEX #IX_#RS_PROD ON #RS_PROD(CD_PROD, CD_FILIAL);
		DROP TABLE #TBL_BASE;

		--Testando se algum dos produtos calculados esta no periodo de sazonalidade (alta temporada), pois os parametros 
		--P1 e P2 so diferenciados

		UPDATE #RS_PROD
		  SET
			  P1 = P1_SAZ
			, P2 = P2_SAZ
			, SAZ = 1
			, MEDIA3M = (p.QT_IT_ATUAL * (arv.P1_SAZ / 100.0000)) + (((p.QT_IT_MES1 + p.QT_IT_MES2 + p.QT_IT_MES3) / 3.0000) * (arv.P2_SAZ / 100.0000))
		FROM EST_PROD_SAZONALIDADE saz
			 INNER JOIN #RS_TMP_ARV arv ON saz.CD_EMP = arv.CD_EMP
										   AND saz.CD_PROD = arv.CD_PROD
			 INNER JOIN #RS_PROD p ON p.CD_FILIAL = arv.CD_FILIAL
									  AND p.CD_PROD = arv.CD_PROD
		WHERE saz.CD_EMP = @CD_EMP
			  AND saz.MES_SAZONALIDADE = MONTH(@AGORA);

		PRINT 'Atualizou a sazionalidade '+CONVERT(VARCHAR, GETDATE(), 108); 
	
		--Analisar valores fora dos limites

		UPDATE #RS_PROD
		  SET
			  QT_IT_ATUAL = CASE
								WHEN QT_IT_ATUAL > LIMITP
								THEN LIMITP --ANALISE DE PICO
								WHEN QT_IT_ATUAL < LIMITV
								THEN LIMITV --ANALISE DE VALES
								ELSE QT_IT_ATUAL
							END
			, QT_IT_MES1 = CASE
							   WHEN QT_IT_MES1 > LIMITP
							   THEN LIMITP --ANALISE DE PICO
							   WHEN QT_IT_MES1 < LIMITV
							   THEN LIMITV --ANALISE DE VALES
							   ELSE QT_IT_MES1
						   END
			, QT_IT_MES2 = CASE
							   WHEN QT_IT_MES2 > LIMITP
							   THEN LIMITP --ANALISE DE PICO
							   WHEN QT_IT_MES2 < LIMITV
							   THEN LIMITV --ANALISE DE VALES
							   ELSE QT_IT_MES2
						   END
			, QT_IT_MES3 = CASE
							   WHEN QT_IT_MES3 > LIMITP
							   THEN LIMITP --ANALISE DE PICO
							   WHEN QT_IT_MES3 < LIMITV
							   THEN LIMITV --ANALISE DE VALES
							   ELSE QT_IT_MES3
						   END;

		PRINT 'Atualizou a pico e vale '+CONVERT(VARCHAR, GETDATE(), 108); 
							 
		--SELECT * FROM #RS_PROD

		IF @CONSULTA = 0
			BEGIN 
		
				--Gravar resultado

				UPDATE t
				  SET
					  QTDE_MEDIAF = ISNULL(CASE
											   WHEN ROUND((r.QT_IT_ATUAL * (r.P1 / 100.0000)) + (((r.QT_IT_MES1 + r.QT_IT_MES2 + r.QT_IT_MES3) / 3.0000) * (r.P2 / 100.0000)), 4) > 0
											   THEN ROUND((r.QT_IT_ATUAL * (r.P1 / 100.0000)) + (((r.QT_IT_MES1 + r.QT_IT_MES2 + r.QT_IT_MES3) / 3.0000) * (r.P2 / 100.0000)), 4)
											   ELSE 0
										   END, 0)
					, SAZ = ISNULL(r.SAZ, 0)
					, QT_VD_ATUAL = ISNULL(r.QT_IT_ATUAL_GRV, 0)
					, QT_VD_MES1 = ISNULL(r.QT_IT_MES1_GRV, 0)
					, QT_VD_MES2 = ISNULL(r.QT_IT_MES2_GRV, 0)
					, QT_VD_MES3 = ISNULL(r.QT_IT_MES3_GRV, 0)
					, LIMITP = ISNULL(r.LIMITP, 0)
					, LIMITV = ISNULL(r.LIMITV, 0)
					, CD_USU = @CD_USU
					, DT_CAD = GETDATE()
					, DT_NASC = R.DT_NASC
				FROM EST_PROD_CPL_MEDIAF t
					 INNER JOIN #RS_PROD r ON t.CD_FILIAL = r.CD_FILIAL
											  AND t.CD_PROD = r.CD_PROD
											  AND t.CD_EMP = @CD_EMP;

				PRINT 'Gravou nova mediaF '+CONVERT(VARCHAR, GETDATE(), 108);

				INSERT INTO EST_PROD_CPL_MEDIAF
				(CD_EMP
			   , CD_FILIAL
			   , CD_PROD
			   , QTDE_MEDIAF
			   , SAZ
			   , VALID_QTDE_FACEAMENTO
			   , QT_VD_ATUAL
			   , QT_VD_MES1
			   , QT_VD_MES2
			   , QT_VD_MES3
			   , LIMITP
			   , LIMITV
			   , DT_NASC
			   , CD_USU
			   , DT_CAD
				)
					   SELECT @CD_EMP AS CD_EMP
							, R.CD_FILIAL
							, R.CD_PROD
							, CASE
								  WHEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4) > 0
								  THEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4)
								  ELSE 0
							  END AS MEDIAF
							, R.SAZ
							, NULL
							, R.QT_IT_ATUAL_GRV
							, R.QT_IT_MES1_GRV
							, R.QT_IT_MES2_GRV
							, R.QT_IT_MES3_GRV
							, R.LIMITP
							, R.LIMITV
							, R.DT_NASC
							, @CD_USU AS CD_USU
							, GETDATE() AS DT_CAD
					   FROM #RS_PROD r
							LEFT JOIN EST_PROD_CPL_MEDIAF F ON R.CD_FILIAL = F.CD_FILIAL
															   AND R.CD_PROD = F.CD_PROD
															   AND F.CD_EMP = @CD_EMP
					   WHERE F.CD_PROD IS NULL;

				PRINT 'Iseriu mediaF para produtos novos '+CONVERT(VARCHAR, GETDATE(), 108); 
				--Registrar data da atualizao na tabela EST_ARV_MD_F_GRP_PARAM, e descartar tabela temporria

				UPDATE p
				  SET
					  FREAV_MEDIAF_ULT_ATU = @AGORA
				FROM EST_ARV_MD_F_GRP_PARAM p
					 JOIN EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL r ON p.CD_EMP = r.CD_EMP
																 AND p.CD_GRP_PARAM = r.CD_GRP_PARAM
					 JOIN EST_ARV_MD_F_GRP_PARAM_EST_ARV_MERC_LINHA l ON p.CD_EMP = l.CD_EMP
																		 AND p.CD_GRP_PARAM = l.CD_GRP_PARAM
					 JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA_CURVA_FILIAL c ON p.CD_EMP = c.CD_EMP
																			 AND r.CD_FILIAL = c.CD_FILIAL
																			 AND p.CD_SIGLA = c.CD_SGL_ATU
																			 AND l.CD_ARV_MERC_LINHA = c.CD_ARV_MERC_LINHA
					 JOIN #RS_PROD b ON r.CD_FILIAL = b.CD_FILIAL
										AND c.CD_PROD = b.CD_PROD
				WHERE p.CD_EMP = @CD_EMP;

				PRINT 'Registrou a data atualizacao na tabela EST_ARV_MD_F_GRP_PARAM '+CONVERT(VARCHAR, GETDATE(), 108); 
	
				--Bkp para auditoria dos dados

				IF EXISTS
				(
					SELECT *
					FROM SYS.TABLES
					WHERE NAME = 'MEDIAFBKP'
				)
					BEGIN
						DROP TABLE MEDIAFBKP;
					END;

				SELECT * INTO MEDIAFBKP
				FROM EST_PROD_CPL_MEDIAF
				WHERE DT_CAD = @AGORA;
				--Fim
			END;
		IF @CONSULTA = 1
			SELECT ROUND((r.QT_IT_ATUAL * (r.P1 / 100.0000)) + (((r.QT_IT_MES1 + r.QT_IT_MES2 + r.QT_IT_MES3) / 3.0000) * (r.P2 / 100.0000)), 4) AS MEDIAF_TST
				 , *
			FROM #RS_PROD r;

		DROP TABLE #RS_PROD;
		DROP TABLE #RS_TMP_ARV;
	END TRY
	BEGIN CATCH
		IF @@NESTLEVEL > 0
			ROLLBACK TRANSACTION;----------------------------------------------------------------------------------

		INSERT INTO ADM_ERRO
		(numero
	   , severidade
	   , estado
	   , rotina
	   , linha
	   , mensagem
	   , dtErro
		)
			   SELECT ERROR_NUMBER() AS numero
					, ERROR_SEVERITY() AS severidade
					, ERROR_STATE() AS estado
					, ERROR_PROCEDURE() AS rotina
					, ERROR_LINE() AS linha
					, ERROR_MESSAGE() AS mensagem
					, GETDATE() AS dtErro;
		RETURN -1;
	END CATCH; 

GO